varying vec2 p_texCoord;

uniform sampler2D blur_texture;

const float blur_size = 1.0 / 512.0; // Assume texture is always 512 x 512

void main(void)
{
    vec4 result_color = vec4(0.0);

   // blur in y (vertical)
   // take nine samples, with the distance blur_size between them
   result_color += texture2D(blur_texture, vec2(p_texCoord.x, p_texCoord.y - 2.5*blur_size)) * 0.2;
   result_color += texture2D(blur_texture, vec2(p_texCoord.x, p_texCoord.y - 1.5*blur_size)) * 0.2;
   result_color += texture2D(blur_texture, vec2(p_texCoord.x, p_texCoord.y)) * 0.2;
   result_color += texture2D(blur_texture, vec2(p_texCoord.x, p_texCoord.y + 1.5*blur_size)) * 0.2;
   result_color += texture2D(blur_texture, vec2(p_texCoord.x, p_texCoord.y + 2.5*blur_size)) * 0.2;
 
   gl_FragColor = result_color;
}
